' ********** Copyright 2019 Roku Corp.  All Rights Reserved. **********

sub Show(args as Object)
   
    m.lib = m.top.FindNode("SampleComponentLib")
    m.lib.observeField("loadStatus", "onLoadStatusChanged")

    m.top.signalBeacon("AppLaunchComplete")
end sub

function onLoadStatusChanged() as void
    if (m.lib.loadStatus = "ready")
        ShowStartScreen()
    endif
end function


Function onChangeScreen(event as object)
    screen = event.getRoSGNode()
    data = event.getdata()
    if data = "LoginScreen"
        ShowLoginScreen()
        if m.CodeScreen <> invalid
            m.CodeScreen.close = true
            m.CodeScreen = invalid
        end if
    else if data = "HomeScreen"
        ShowHomeScreen()
    else if screen.id = "CodeScreen"
        if data = "accessCode"
            ShowKeyboard("Enter access code below", "", screen.id)
        else if data = "invalidCode"
            ShowDialog("Wrong Access Code",m.CodeScreen.invalidCode.Msg)
        end if
    end if
End function

sub ShowCodeScreen()
    'UpdateThemeTop()

    m.CodeScreen = CreateObject("roSGNode", "SampleComponentLib:CodeScreen")
    m.CodeScreen.id = "CodeScreen"
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        HandlerConfigCodeScreen: {
            name: "CodeScreenHandler",
            FieldChanged : "SetContent"
        }
    })
    m.CodeScreen.content = content
    m.top.ComponentController.CallFunc("show", {
        view: m.CodeScreen
    })
    m.CodeScreen.ObserveField("screen","onChangeScreen")
end sub


sub ShowLoginScreen()
    'UpdateThemeTop()

    m.LoginScreen = CreateObject("roSGNode", "SampleComponentLib:LoginScreen")
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        HandlerConfig: {
            name: "LoginScreenHandler"
        },
        FieldChanged : "SetContent"
    })

    m.LoginScreen.content = content
    m.LoginScreen.ObserveField("screen", "ChangeScreen")

    m.top.ComponentController.CallFunc("show", {
        view: m.LoginScreen
    })

    if m.HomeScreen <> invalid
        m.HomeScreen.close = true
        m.HomeScreen = invalid
    end if
end sub

sub ShowPrepareScreen()
    m.PrepareScreen = CreateObject("roSGNode", "SampleComponentLib:PrepareScreen")
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        HandlerConfig: {
            name: "PrepareScreenHandler"
        },
        FieldChanged : "SetContent"
    })
    m.PrepareScreen.content = content
    m.PrepareScreen.ObserveField("screen", "onChangeScreen")
    m.top.ComponentController.CallFunc("show", {
        view: m.PrepareScreen
    })

end sub

sub ShowStartScreen()
    m.StartScreen = CreateObject("roSGNode", "SampleComponentLib:StartScreen")
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        HandlerConfig: {
            name: "StartScreenHandler"
        },
        FieldChanged : "SetContent"
    })
    m.StartScreen.content = content
    m.StartScreen.ObserveField("screen", "ChangeScreen")
    m.top.ComponentController.CallFunc("show", {
        view: m.StartScreen
    })
end sub



sub ShowLiveScreen()
    if m.HomeScreen <> invalid
        m.HomeScreen.findnode("Video").control = "stop"
    end if
    m.LiveScreen = CreateObject("roSGNode", "SampleComponentLib:LiveScreen")
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        HandlerConfigLiveScreen: {
            name: "LiveScreenHandler"
        },
        FieldChanged : "Contentset"
    })
    m.top.ComponentController.CallFunc("show", {
        view: m.LiveScreen
    })
    m.LiveScreen.content = content
end sub


sub ShowHomeScreen()
    m.HomeScreen = CreateObject("roSGNode", "SampleComponentLib:HomeScreen")
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        HandlerConfig: {
            name: "HomeScreenHandler"
        },
        FieldChanged : "SetContent"
    })
    m.HomeScreen.content = content
    m.HomeScreen.ObserveField("screen", "ChangeScreen")
    m.HomeScreen.ObserveField("rowItemSelected", "onMenuItemSelected")
    m.HomeScreen.ObserveField("SiderowItemSelected", "onSideMenuItemSelected")

    m.top.ComponentController.CallFunc("show", {
        view: m.HomeScreen
    })
    if RegistryUtil().read("pin", m.global.manifest.key) = invalid
        ShowPinDialog("Set PIN", "Set PIN")
    end if

    if m.PrepareScreen <> invalid
        m.PrepareScreen.close = true
        m.PrepareScreen = invalid
    end if
end sub

Function onMenuItemSelected(event as Object)
    index = event.GetData()
    data = m.HomeScreen.findnode("menuList").content.getchild(index[0]).getchild(index[1])
    if data.title = "Live TV"
        ShowLiveScreen()
    else if data.title = "Programme Guide"
        if m.global.Cdata.app_conf.epg_roku = "true"
            m.global.setFields({timegrid : "Programme Guide"})
            TimeGridView()    
        else
            ShowDialog("EPG", "EPG has been disabled") 
        end if
    else if data.title = "Catch Up"
        if m.global.Cdata.app_conf.epg_roku = "true" and m.global.Cdata.app_conf.epg_catchup = "true"
            m.global.setFields({timegrid : "Catch Up"})
            TimeGridView()    
        else
            ShowDialog("Catch up", "Catch up has been disabled") 
        end if
    else if data.title = "Movies"
        ShowMoviesScreen("movies")
    else if data.title = "TV Shows"
        ShowMoviesScreen("tvshows")    
    else if data.title = "My Account"
        m.HomeScreen.screen = "dialog/AccountInfo"
    else if data.title = "Settings"
        m.HomeScreen.screen = "dialog/Settings"
    else if data.title = "Log out"
        m.HomeScreen.screen = "dialog/are you really want to logout?/Log out"
    end if
End Function

Function onSideMenuItemSelected(event as object)
    index = event.GetData()
    if index[0] = 0
        m.global.setFields({timegrid : "live"})
        TimeGridView()
    else if index[0] = 1
        m.global.setFields({timegrid : "catchup"})
        TimeGridView()    
    else if index[0] = 2
        m.global.setFields({timegrid : "movies"})
        ShowMoviesScreen("movies")
    else if index[0] = 3
        m.global.setFields({timegrid : "catchup"})
        ShowMoviesScreen("tvshows")   
    else if index[0] = 4
        ShowFavoriteScreen()
    else if index[0]  = 5
        m.HomeScreen.screen = "dialog/Settings"  
        'm.HomeScreen.screen = "dialog/AccountInfo"     
    else if index[0] = 6    
        m.HomeScreen.screen = "dialog/are you really want to logout?/Log out"
    end if
End function


sub TimeGridView()
    
    if m.TimeGridView <> invalid
        m.TimeGridView.close = true
    end if

    m.TimeGridView = CreateObject("roSGNode", "SampleComponentLib:TimeGridView")
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        HandlerConfigTimeGrid: {
            name: "CHRoot"
        }
    })
    m.TimeGridView.content = content
    m.TimeGridView.ObserveField("screen", "ChangeScreen")
    m.top.ComponentController.CallFunc("show", {
        view: m.TimeGridView
    })
end sub

sub ShowMoviesScreen(content_type as string)
    m.MoviesScreen = CreateObject("roSGNode", "SampleComponentLib:MoviesScreen")
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        HandlerConfig: {
            name: "MoviesScreenHandler"
        },
        content_type : content_type,
        FieldChanged : "SetContent"
    })
    m.MoviesScreen.content = content
    m.MoviesScreen.ObserveField("screen", "ChangeScreen")
    m.MoviesScreen.ObserveField("ItemSelected", "onItemSelected")
    m.top.ComponentController.CallFunc("show", {
        view: m.MoviesScreen
    })
end sub


Function onItemSelected(event as Object)
    index = event.GetData()
    data = event.GetRoSGNode().findnode("grid").content.getchild(index[0]).getchild(index[1])
    ShowSingleScreen(data)
End Function

sub ShowFavoriteScreen()
    m.FavoriteScreen = CreateObject("roSGNode", "SampleComponentLib:FavoriteScreen")
    m.FavoriteScreen.theme = {
        global: {
            backgroundImageURI: ""
            backgroundColor : "#242B31"
        }
    }
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        FieldChanged : "SetContent"
    })
    m.FavoriteScreen.content = content
    m.FavoriteScreen.ObserveField("screen", "ChangeScreen")
    m.FavoriteScreen.ObserveField("ItemSelected", "onItemSelected")
    m.top.ComponentController.CallFunc("show", {
        view: m.FavoriteScreen
    })
end sub

Function ShowSingleScreen(data as Object)
    m.SingleScreen = CreateObject("roSGNode", "SampleComponentLib:SingleScreen")
    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        HandlerConfig: {
            name: "SingleScreenHandler"
        },
        itemdata : data
        FieldChanged : "SetContent"
    })

    m.SingleScreen.content = content
    m.SingleScreen.ObserveField("screen", "ChangeScreen")
    m.SingleScreen.ObserveField("rowItemSelected", "OnSeasonItemSelected")
    m.SingleScreen.ObserveField("VideoContent","OnVideoContentChagned")

    m.top.ComponentController.CallFunc("show", {
        view: m.SingleScreen
    })
End Function

Function OnSeasonItemSelected(event as Object)
    content = event.getRoSGNode().findnode("grid").content.getchild(event.getdata()[0])
    OpenVideoPlayer(content, event.getdata()[1],true)
End Function

Function OnVideoContentChagned(event as Object)
    OpenVideoPlayerItem(event.getdata())
End Function


Function ShowParentSelectorScreen()
    m.ParentSelectorScreen = CreateObject("roSGNode", "SampleComponentLib:ParentSelectorScreen")

    content = CreateObject("roSGNode", "ContentNode")
    content.AddFields({
        FieldChanged : "SetContent"
    })

    m.ParentSelectorScreen.content = content
    m.top.ComponentController.CallFunc("show", {
        view: m.ParentSelectorScreen
    })
End Function


Function ChangeScreen(event as Object)
    screen = event.GetData()
    if event.getdata().Tokenize("/").count() = 2 or event.getdata().Tokenize("/").count() = 3
        screen = event.getdata().Tokenize("/")
        if screen[0] = "LoginScreen" or screen[0] = "MoviesScreen"
            if screen[2] <> invalid
                ShowKeyboard(screen[1],screen[2],screen[0])
            else
                ShowKeyboard(screen[1],"",screen[0])
            end if 
        else if screen[0] = "dialog"
             if screen.count() = 3
                ShowDialog(screen[2], screen[1])
             else if screen[1] = "AccountInfo"
                userInfo = RegistryUtil().read("UserInfo", m.global.manifest.key)
                info = Parsejson(userInfo).user_info
                if info.exp_date = invalid 
                    exp = ""
                else
                    exp = info.exp_date
                end if
                ShowDialog("My Account", MyAccountInfo())
             else if screen[1] = "Settings"
                ShowDialog("Settings", "Please Select option from below") 
             else if screen[1] = "Parental Control"
                ShowDialog("Parental Control", "Please Select option from below") 
             else if screen[1] = "Media Format"
                ShowDialog("Media Format", "Please Select option from below")     
             else
                ShowDialog("Login", screen[1])
             end if
        else if screen[0] = "messageDailog"

        end if
    else if screen = "HomeScreen"
        ShowHomeScreen()
        if m.PrepareScreen <> invalid
            m.PrepareScreen.close = true
            m.PrepareScreen = invalid
        end if
    else if screen = "CodeScreen"
        ShowCodeScreen()
        if m.StartScreen <> invalid
            m.StartScreen.close = true
            m.StartScreen = invalid
        end if
    else if screen = "PrepareScreen"    
        ShowPrepareScreen()
    else if screen = "LoginScreen"
        ShowLoginScreen()    
        if m.HomeScreen <> invalid
            m.HomeScreen.close = true
            m.HomeScreen = invalid
        end if
    else if screen = "LiveScreen"
        ShowLiveScreen()
    else if screen = "Parental" or screen = "LiveParental"
        ShowParentPinDialog("Enter your PIN",screen)   
    else if screen = "CodeScreen"
        ShowCodeScreen()
        if m.LoginScreen <> invalid
            m.LoginScreen.close = true
            m.LoginScreen = invalid
        end if 
    end if
End Function


sub ShowDialog(title as string, message as string)
    m.dialog = createObject("roSGNode", "dialog")
    m.dialog.title = title

    if len(message) > 500
        m.dialog.width = "1600"
    end if
    m.dialog.message = message

    if title = "Log out"    
        m.dialog.buttons = ["Yes","No"]
    else if title = "Sort By"
        m.dialog.buttons = ["By A-Z","By Z-A", "By Added"]
    else if title =  "Settings"
        m.dialog.buttons = ["Parental Control", "Media Format"]    
    else if title = "Media Format"  
        if RegistryUtil().read("format", m.global.manifest.key)  = "M3U8"
            m.dialog.buttons = ["M3U8 (On)","TS"] 
        else
            m.dialog.buttons = ["M3U8","TS (On)"] 
        end if
    else if title = "Parental Control"
        if RegistryUtil().read("pin", m.global.manifest.key) = invalid
            m.dialog.buttons = ["Set PIN","Add Categories"]                   
        else
            m.dialog.buttons = ["Change PIN","Unlock Parental Control Access","Add Categories to Parental Control"]
        end if   
    else
        m.dialog.buttons = ["Dismiss"]
    end if

    m.dialog.ObserveField("buttonselected","OndialogButtonSelected")
    m.top.dialog = m.dialog
end sub


Function OndialogButtonSelected(event as Object)
    if m.dialog.buttons[event.getdata()] = "Dismiss"
        if m.dialog.title = "PIN"
            m.top.dialog.close = true
            ShowDialog("Parental Control", "Please Select option from below") 
        else
            m.top.dialog.close = true
        end if
    else if m.dialog.buttons[event.getdata()] = "By A-Z" or m.dialog.buttons[event.getdata()] = "By Z-A" or m.dialog.buttons[event.getdata()] = "By Added"
        if m.MoviesScreen <> invalid
            m.MoviesScreen.CallFunc("SortBy", {
                sort : m.dialog.buttons[event.getdata()]
            })
        end if
        m.top.dialog.close = true
    else if m.dialog.buttons[event.getdata()] = "Yes"  
        m.HomeScreen.screen = "LoginScreen"
        m.top.dialog.close = true 
    else if m.dialog.buttons[event.getdata()] = "My Account"   
        m.top.dialog.close = true 
        m.HomeScreen.screen = "dialog/AccountInfo"
    else if m.dialog.buttons[event.getdata()] = "Media Format"    
        m.top.dialog.close = true 
        ShowDialog("Media Format", "Please Select option from below")  
    else if m.dialog.buttons[event.getdata()] = "Parental Control"    
        m.HomeScreen.screen = "dialog/Parental Control"
    else if m.dialog.buttons[event.getdata()] = "Change PIN"
        ShowPinDialog("Enter your current PIN", "Change PIN")
    else if m.dialog.buttons[event.getdata()] = "Unlock Parental Control Access"
        ShowPinDialog("Enter your Parental Control PIN", "Unlock Parental Control Cotent Access")
    else if m.dialog.buttons[event.getdata()] = "Set PIN"
        ShowPinDialog(m.dialog.buttons[event.getdata()], "Set PIN")
    else if m.dialog.buttons[event.getdata()] = "M3U8" or m.dialog.buttons[event.getdata()] = "TS"  
        RegistryUtil().write("format",m.dialog.buttons[event.getdata()], m.global.manifest.key)
        m.top.dialog.close = true 
    else if m.dialog.buttons[event.getdata()] = "Add Categories to Parental Control" 
        if m.global.ParentalLock = false
            m.top.dialog.close = true 
            ShowParentSelectorScreen() 
        else
            m.top.dialog.close = true 
            ShowDialog("Parental Control Categories", "Unlock Parental Control Cotent Access.")  
        end if 
    end if  
end Function

sub ShowPinDialog(title as string, message as string)
    m.dialog = createObject("roSGNode", "PinDialog")
    m.dialog.title = title

    if title = "Enter your current PIN"
        m.dialog.buttons = ["OK","Dismiss"]
    else if title = "Enter your Parental Control PIN"
        m.dialog.buttons = ["Unlock Now","Dismiss"]
    else    
        m.dialog.buttons = ["Set PIN","Dismiss"]
    end if    

    m.dialog.ObserveField("buttonselected","OnPINdialogButtonSelected")
    m.top.dialog = m.dialog
end sub

sub OnPINdialogButtonSelected(event as object)
    if m.dialog.buttons[event.getdata()] = "OK"
        m.top.dialog.close = true 
        if m.dialog.pin = RegistryUtil().read("pin",m.global.manifest.key)
            ShowPinDialog("Enter new PIN", "Set PIN")
        else
            ShowDialog("PIN", "You have enter wrong your current PIN")     
        end if
    else if m.dialog.buttons[event.getdata()] = "Set PIN" or m.dialog.buttons[event.getdata()] = "Enter new PIN"
        RegistryUtil().write("pin", m.dialog.pin,m.global.manifest.key) 
        m.top.dialog.close = true
        ShowDialog("Parental Control", "Please Select option from below") 
    else if m.dialog.buttons[event.getdata()] = "Unlock Now"
        pin = m.dialog.pin
        m.top.dialog.close = true
        if RegistryUtil().read("pin",m.global.manifest.key) <> invalid and pin = RegistryUtil().read("pin",m.global.manifest.key)
            m.global.setFields({ParentalLock : false})
            ShowDialog("Parental control content access","You have now access of all content")
        else
            ShowDialog("Parental control content access","Wrong parental control code")
        end if
    end if    
end sub


sub ShowParentPinDialog(title as string, message as string)
    m.dialog = createObject("roSGNode", "PinDialog")
    m.dialog.title = title
    m.mScreen = message
    m.dialog.buttons = ["OK","Dismiss"]    

    m.dialog.ObserveField("buttonselected","ValidatePasscode")
    m.top.dialog = m.dialog
end sub

sub ValidatePasscode(event as object)
    if m.dialog.buttons[event.getdata()] = "OK"
        if RegistryUtil().read("pin",m.global.manifest.key) = m.dialog.pin
            if m.mScreen = "Parental"
                m.MoviesScreen.CallFunc("MakeUpdate", {})
            else m.mScreen = "LiveParental"  
                m.grid.CallFunc("MakeUpdate", {})
            end if  
            m.top.dialog.close = true
        end if
    else
        m.top.dialog.close = true
    end if    
end sub


sub ShowKeyboard(title as string,text as string, screen as string)
    m.KeyboardDialog = createObject("roSGNode", "KeyboardDialog")
    m.KeyboardDialog.title = title
    if title = "Password"
        m.KeyboardDialog.keyboard.textEditBox.secureMode = true
    end if
    m.KeyboardDialog.text = text
    m.KeyboardDialog.AddFields({screen : screen})
    m.KeyboardDialog.buttons = ["Enter","Dismiss"]
    m.KeyboardDialog.ObserveField("buttonselected","OnkeyboardButtonSelected")
    m.top.dialog = m.KeyboardDialog
end sub

Function OnkeyboardButtonSelected(event as Object)
    if event.getdata() = 0
        if m.KeyboardDialog.screen = "LoginScreen"    
            m.LoginScreen.CallFunc("SetText", {text: m.KeyboardDialog.text, field : m.KeyboardDialog.title})
        else if m.KeyboardDialog.screen = "MoviesScreen"    
            m.MoviesScreen.CallFunc("Searchdata", {keyword: m.KeyboardDialog.text})
        else if m.KeyboardDialog.screen = "CodeScreen"
            m.CodeScreen.CallFunc("SetText",{text: m.KeyboardDialog.text})
        end if
    end if
    m.top.dialog.close = true
End Function

function MyAccountInfo()
    userInfo = RegistryUtil().read("UserInfo", m.global.manifest.key)
    userdata = Parsejson(userInfo).user_info

    message =  ""
    if userdata.message <> invalid
        message = message + userdata.message + chr(10) 
    end if

    if userdata.status <> invalid
        message = message + "Status: " + userdata.status + chr(10) 
    end if

    if userdata.max_connections <> invalid
        message = message + "Maximun Connection: " + userdata.max_connections + chr(10) 
    end if

    if userdata.exp_date <> invalid
        date = CreateObject("roDateTime")
        if type(userdata.exp_date) = "roString" or type(userdata.exp_date) = "String" 
            date.FromSeconds(userdata.exp_date.toint())
        else
            date.FromSeconds(userdata.exp_date)
        end if
        date.ToLocalTime()
        
        message = message + "Expire on: " + date.AsDateString("long-date") + chr(10) 
    else
        message = message + "Expire on: Unlimited"+ chr(10)     
    end if

    return message
end function