sub init()
    m.global.setFields({Cdata:{}})
    RegistryUtil().delete("Code",m.global.manifest.key)
    RegistryUtil().delete("UserInfo",m.global.manifest.key)
    
    m.LoginGroup = m.top.findnode("LoginGroup")
    m.noContent = m.top.findnode("noContent")

    m.spinner = m.top.findNode("spinner")
    m.spinner.uri = "pkg:/components/SGDEX/Images/loader.png"

    m.accessCode = m.top.findnode("accessCode")
    m.logo = m.top.findnode("logo")

    m.top.ObserveField("wasShown", "OnWasShown")
    m.top.ObserveField("content", "Oncontentset")

    m.lastfocused = invalid

    m.backRec = m.top.findnode("backRec")
    m.backRec.color = GetTheme("roku_background_overlay")

end sub

Function UpdateThemeTop()
    if m.global.Cdata.app_image <> invalid and m.global.Cdata.app_image.app_img = "true"
        back_image = m.global.Cdata.app_image.back_image
        back_color = m.global.Cdata.background.roku_color_primary
    else if m.global.Udata.app_image.app_img = "true" and m.global.Cdata.app_image <> invalid
        back_image = m.global.Udata.app_image.back_image
        back_color = m.global.Udata.background.roku_color_primary
    else
        back_image = "pkg:/images/bg.png"
        back_color = "#2E373D"
    end if

    scene = m.top.getScene()
    scene.updateTheme = {
        global: {
            backgroundImageURI: back_image
            OverhangVisible : "false"
            backgroundColor: back_color
        }
    }
End function

function OnWasShown()
    ShowBusySpinner(false)
    m.accessCode.active = true

    UpdateThemeTop()

    if m.global.Udata.app_image.app_img = "false"
        m.logo.uri = "pkg:/images/logo_wide.png"
    else
        m.logo.uri = m.global.Udata.app_image.app_logo
    end if 
end function

function Oncontentset()
    if m.top.content <> invalid
        if m.top.content.FieldChanged <> invalid
            FieldChanged = m.top.content.FieldChanged
            m.top.content.SetFields({FieldChanged : invalid })
            if FieldChanged = "Codedata"
                ShowBusySpinner(false)
                data = m.top.content.Codedata
                if data.licence <> invalid 
                    m.top.invalidCode = data
                    m.top.screen = "invalidCode"
                    m.top.invalidCode = data
                else
                    m.global.SetFields({Cdata : data})
                    RegistryUtil().write("Cdata",FormatJson(data),m.global.manifest.key)
                    m.top.screen = "LoginScreen"
                end if
            end if
        end if
    end if
end function   


Function SetText(event as object)
    if event.text <> ""
        m.top.accessCodeText = event.text
        
        'm.accessCode.text = "3F1D05"
        m.accessCode.cursorPosition  = len(event.text)
    end if
    MakeLoginRequest()
End function


function MakeLoginRequest()
    if m.top.content <> invalid and m.top.content.HandlerConfigCodeScreen <> invalid then
        HandlerConfig = m.top.content.HandlerConfigCodeScreen
        additional = {
            query : m.accessCode.text
        }
        LoadMoreContent(m.top.content, HandlerConfig, additional)
    end if
end function

sub LoadMoreContent(content, HandlerConfig, additional)
    ShowBusySpinner(true)

    callback = {
        config: HandlerConfig
        content: content

        onReceive: function(data)
            m.SetContent(data)
        end function

        onError: function(data)
            if m.content.HandlerConfigCustom <> invalid then
                m.config = m.content.HandlerConfigCustom
                m.content.HandlerConfigCustom = invalid
                GetContentData(m, m.config, m.content)
            end if
        end function

        setContent: sub(content)
            ShowBusySpinner(false)
        end sub
    }

    GetContentData(callback, HandlerConfig, content, additional)
end sub

sub ShowBusySpinner(shouldShow)
    if shouldShow then
        if not m.spinner.visible then
            m.spinner.visible = true
            m.spinner.control = "start"
        end if
    else
        m.spinner.visible = false
        m.spinner.control = "stop"
    end if
end sub


function onkeyEvent(key as String, press as Boolean) as Boolean
    handled = false
    if press
        if key="OK"     
             if m.noContent.hasfocus()
                m.top.screen = "accessCode"
             end if
        end if
    end if    
    return handled
end function