Function init()
    m.logo = m.top.findnode("logo")

    m.grid = m.top.findnode("grid")
    m.grid.ObserveField("rowItemSelected","onMovieSelected")
    m.grid.ObserveField("rowItemfocused","onMoviefocusedchanged")

    m.top.ObserveField("wasShown", "OnWasShown")
    m.top.ObserveField("content", "OnContentChange")

    m.keyword = ""
End Function


sub OnContentChange()
   if m.top.content <> invalid
      if m.top.content.FieldChanged <> invalid
        FieldChanged = m.top.content.FieldChanged
        m.top.content.SetFields({FieldChanged : invalid})
        if FieldChanged = "SetContent"
            if m.global.basedata <> invalid
                m.logo.uri = m.global.basedata.app_image.app_logo
            end if
            setupGrid()
        end if
      end if
   end if
end sub


Function OnWasShown()
    if m.lastfocus <> invalid
        m.lastfocus.setfocus(true)
    else
        setupGrid()
        m.lastfocus = m.grid  
    end if
End Function


Function onMoviefocusedchanged(event as object)
    index = event.getdata()
    data = m.grid.content.getchild(index[0]).getchild(index[1])
End Function


function setupGrid()
    content = CreateObject("roSGNode", "ContentNode")
    cons = []
    fav = RegistryUtil().read("fav", "user")
    if fav <> invalid and ParseJson(fav).count() > 0
        cons.push({title : "Movies", con : ParseJson(fav)})
    end if

    fav = RegistryUtil().read("sfav", "user")
    if fav <> invalid and ParseJson(fav).count() > 0
        cons.push({title : "TV Shows", con : ParseJson(fav)})
    end if

    for each con in cons
        row = CreateObject("roSGNode", "ContentNode")
        row.title = con.title
        for each asset in con.con
            item = CreateObject("roSGNode", "ContentNode")
            item.id = asset.id
            item.title = asset.title
            item.CONTENTTYPE = asset.CONTENTTYPE
            item.hdposterUrl = asset.hdposterUrl
            row.appendChild(item)
        end for
        content.appendChild(row)
    end for
    m.grid.content = content
end function




function onKeyEvent(key as String, press as Boolean) as Boolean
    handled = false
    if press
        if key = "left" and m.grid.HasFocus()
          
        end if
    end if
    return handled
end function



