Function init()
    m.sideMenuBack = m.top.findnode("sideMenuBack")
    m.SideMenuList = m.top.findnode("SideMenuList")
    m.SideMenuList.ObserveField("rowItemSelected","onCategorySelected")

    m.grid = m.top.findnode("grid")
    m.grid.ObserveField("rowItemSelected","onMovieSelected")
    m.grid.ObserveField("rowItemfocused","onMoviefocusedchanged")

    m.elementTimer = m.top.findnode("elementTimer")
    m.elementTimer.ObserveField("fire", "OnelementTimerFire")

    m.menuAnimation = m.top.findnode("menuAnimation")
    m.translationAnimation = m.top.findnode("translationAnimation")
    m.rectranslationAnimation = m.top.findnode("rectranslationAnimation")

    m.spinner = m.top.FindNode("spinner")
    m.spinner.uri = "pkg:/components/SGDEX/Images/loader.png"

    m.lastfocus = invalid


    m.Topbuttons = m.top.findnode("Topbuttons")
    m.Topbuttons.ObserveField("rowitemselected", "OnTopbuttonSelected")

    m.top.ObserveField("wasShown", "OnWasShown")
    m.top.ObserveField("content", "OnContentChange")

    m.title = m.top.findnode("title")

    m.keyword = ""

    m.exacute = ""

    m.SideMenuList.focusBitmapBlendColor = GetTheme("roku_color_secondary")
    m.grid.focusBitmapBlendColor = GetTheme("roku_color_secondary")

    m.mainRec = m.top.findnode("mainRec")

    m.noContent = m.top.findnode("noContent")

    m.backRec = m.top.findnode("backRec")
    m.backRec.color = GetTheme("roku_background_overlay")

    m.sideMenuBack.color = GetTheme("roku_color_primary")
End Function

function OnelementTimerFire()
    m.SideMenuList.setfocus(true)
End function

sub OnContentChange()
   if m.top.content <> invalid
      if m.top.content.FieldChanged <> invalid
        FieldChanged = m.top.content.FieldChanged
        m.top.content.SetFields({FieldChanged : invalid})
        if FieldChanged = "SetContent"
            setupTopButtons()
            if m.top.content <> invalid and m.top.content.HandlerConfig <> invalid then
                HandlerConfig = m.top.content.HandlerConfig
                if m.top.content.content_type = "movies"
                    SetupCategoriesList(GetCats())
                    additionalFields = {
                        id : "GetMovies"
                        query : GetCats()[1].category_id
                    }
                    m.top.findnode("screenTitle").text = "Movies | "+GetCats()[1].category_name
                else
                    SetupCategoriesList(GetCats())
                    additionalFields = {
                        id : "GetTVShows"
                        query : GetCats()[1].category_id
                    }
                    m.top.findnode("screenTitle").text = "TV Shows | "+GetCats()[1].category_name
                end if
                LoadMoreContent(m.top.content, HandlerConfig,additionalFields)
            end if
            ShowBusySpinner(true)
            
        else if FieldChanged = "MoviesCategories"
            SetupCategoriesList(m.top.content.MoviesCategories)
        else if FieldChanged = "AllMovies" 
            if m.keyword = ""
                m.grid.content = ConvetToRowlistContent(m.top.content.AllMovies)
            else
                content = SearchdataForKeyword(m.top.content.AllMovies)
                m.grid.content = ConvetToRowlistContent(content)
                m.keyword = ""
            end if
            ShowBusySpinner(false)
            m.grid.visible = true
        else if FieldChanged = "TVShowsCategories"
            SetupCategoriesList(m.top.content.TVShowsCategories)   
        else if FieldChanged = "AllTVShows" 
            if m.keyword = ""
                m.grid.content = ConvetToRowlistContent(m.top.content.AllTVShows)
            else
                content = SearchdataForKeyword(m.top.content.AllTVShows)
                m.grid.content = ConvetToRowlistContent(content)
                m.keyword = ""
            end if
            ShowBusySpinner(false)
            m.grid.visible = true 
        end if
      end if
   end if
end sub


Function GetCats()
    cats = []
    if m.top.content.content_type = "movies"
        if m.global.moviesCats <> invalid 
            if RegistryUtil().read("pmovie",m.global.manifest.key) <> invalid
                m.Pcat = ParseJson(RegistryUtil().read("pmovie",m.global.manifest.key))
            else
                m.Pcat = []
            end if
            for each catItem in m.global.moviesCats
                if m.global.ParentalLock = false
                    cats.Push(catItem)
                else if ArrayUtil().contains(m.Pcat,catItem.category_id) = false
                    cats.Push(catItem)
                end if
            end for
        end if
        return cats
    else
        if m.global.tvshowsCats <> invalid 
            if RegistryUtil().read("pshows",m.global.manifest.key) <> invalid
                m.Pcat = ParseJson(RegistryUtil().read("pshows",m.global.manifest.key))
            else
                m.Pcat = []
            end if
            for each catItem in m.global.tvshowsCats
                if m.global.ParentalLock = false
                    cats.Push(catItem)
                else if ArrayUtil().contains(m.Pcat,catItem.category_id) = false
                    cats.Push(catItem)
                end if
            end for
        end if
        return cats
    end if
End function

Function SearchdataForKeyword(data as object)
    content = []
    if data <> invalid
        for each item in data
            r = CreateObject("roRegex",LCase(m.keyword),"")
            check = r.IsMatch(LCase(item.name))
            if check = true
                content.push(item)
            end if
        end for
    end if
    return content
End Function

Function SortBy(event as object)
    if m.top.content.content_type = "movies"
        data = m.top.content.AllMovies
    else
        data = m.top.content.AllTVShows
    end if    
    if event.sort = "By A-Z"
        data.SortBy("name") 
    else if event.sort = "By Z-A"
        data.SortBy("name")
        data.Sort("r") 
    else if event.sort = "By Added"
        data.SortBy("added") 
    end if
    m.grid.content = ConvetToRowlistContent(data)
End Function

Function Searchdata(event as object)
    if event.keyword <> invalid and event.keyword <> ""
        m.keyword = event.keyword
        m.grid.visible = false
        HandlerConfig = m.top.content.HandlerConfig
        if m.top.content.content_type = "movies"
            additionalFields = {
                id : "GetMovies"
                query : ""
            }
            m.top.findnode("screenTitle").text = "Movies | Search"
        else
            additionalFields = {
                id : "GetTVShows"
                query :""
            }
            m.top.findnode("screenTitle").text = "TV Shows | Search"
        end if
        LoadMoreContent(m.top.content, HandlerConfig,additionalFields)

        ShowBusySpinner(true)
    end if
End Function


Function OnWasShown()
    if m.lastfocus <> invalid
        m.lastfocus.setfocus(true)
    else
        m.lastfocus = m.grid  
    end if
End Function

Function MakeUpdate(event as object)
    
    data = m.exacute.Tokenize("/")
    if data[1] = "cat"
        index = m.SideMenuList.rowitemselected
        data = m.SideMenuList.content.getchild(index[0]).getchild(index[1])
        if m.top.content <> invalid and m.top.content.HandlerConfig <> invalid then
            HandlerConfig = m.top.content.HandlerConfig
            if m.top.content.content_type = "movies"
                additionalFields = {
                    id : "GetMovies"
                    query : data.category_id
                }
                m.top.findnode("screenTitle").text = "Movies | "+data.category_name
            else
                additionalFields = {
                    id : "GetTVShows"
                    query : data.category_id
                }
                m.top.findnode("screenTitle").text = "TV Shows | "+data.category_name
            end if
            LoadMoreContent(m.top.content, HandlerConfig,additionalFields)
        end if
        m.grid.visible = false
        ShowBusySpinner(true)
        m.grid.content = invalid
    end if
End function

function onCategorySelected(event as object)
    m.title.text = ""
    m.Topbuttons.visible = false

    if m.top.content.content_type = "movies"
        ids = RegistryUtil().read("pmovie","user")
    else
        ids = RegistryUtil().read("pshows","user")
    end if

    if ids <> invalid
        ids = ParseJson(ids)
    else
        ids = []
    end if

    index = event.getdata()
    data = m.SideMenuList.content.getchild(index[0]).getchild(index[1])

    if ArrayUtil().contains(ids,data.id.toStr())
        m.exacute = data.id
        if m.top.content.content_type = "movies"
            m.exacute =  "Movies/cat/Unlock"
        else
            m.exacute =  "shows/cat/Unlock"
        end if   
        m.top.screen = "Parental" 
    else
        if m.top.content <> invalid and m.top.content.HandlerConfig <> invalid then
            HandlerConfig = m.top.content.HandlerConfig
            if m.top.content.content_type = "movies"
                additionalFields = {
                    id : "GetMovies"
                    query : data.category_id
                }
                m.top.findnode("screenTitle").text = "Movies | "+data.category_name
            else
                additionalFields = {
                    id : "GetTVShows"
                    query : data.category_id
                }
                m.top.findnode("screenTitle").text = "TV Shows | "+data.category_name
            end if
            LoadMoreContent(m.top.content, HandlerConfig,additionalFields)
        end if
        m.grid.visible = false
        ShowBusySpinner(true)
        m.grid.content = invalid
    end if
    setAnimation("right")
end function

Function onMoviefocusedchanged(event as object)
    index = event.getdata()
    data = m.grid.content.getchild(index[0]).getchild(index[1])
    m.title.text = data.name
End Function

Function SetupCategoriesList(Categories as object)
    content = CreateObject("roSGNode", "ContentNode")
    for each Category in Categories
        row = CreateObject("roSGNode", "ContentNode")
        item = CreateObject("roSGNode", "ContentNode")
        item.update(Category,true)
        row.appendChild(item)
        content.appendChild(row)
    end for
    m.SideMenuList.content = content
End Function

Function setupTopButtons()
    datas = ["sort","search"]
    content = CreateObject("roSGNode", "ContentNode")
    row = CreateObject("roSGNode", "ContentNode")
    for each data in datas
        item = CreateObject("roSGNode", "ContentNode")
        item.id = data
        item.title = " "
        item.hdPosterUrl = "pkg:/images/"+data+".png"
        row.appendChild(item)
    end for
    content.appendChild(row)
    m.Topbuttons.content = content
End Function

Function OnTopbuttonSelected(event as object)
    index = event.getdata()
    if index[1] = 0
        m.top.Screen = "dialog/Please select from below option/Sort By"
    else if index[1] = 1
        m.top.Screen = "MoviesScreen/Enter KeyWord"
    end if
End Function

function onKeyEvent(key as String, press as Boolean) as Boolean
    handled = false
    if press
        if key = "left" and m.grid.HasFocus()
            setAnimation("left")
            handled = true
        else if key = "right" and m.SideMenuList.HasFocus()
            setAnimation("right")
            handled = true
        else if key = "up" 
            if m.grid.hasfocus() 
                m.Topbuttons.setfocus(true)
            end if  
        else if key = "down"
            if m.Topbuttons.hasfocus() 
                m.grid.setfocus(true)
            end if 
        end if
    end if
    return handled
end function

Function setAnimation(key as String)
    if key = "left"
        if m.sideMenuBack.translation[0] = -400
            m.translationAnimation.keyValue = [[-400,0],[0,0]]
            m.rectranslationAnimation.keyValue = [[0,0],[400,0]]
            m.menuAnimation.control = "start"
            m.elementTimer.control = "start"
            m.lastfocus = m.SideMenuList
        end if
    else if key = "right"
        if m.sideMenuBack.translation[0] = 0
            m.translationAnimation.keyValue = [[0,0],[-400,0]]
            m.rectranslationAnimation.keyValue = [[400,0],[0,0]]
            m.menuAnimation.control = "start"
            m.grid.setfocus(true)
            m.lastfocus = m.grid
        end if
    end if
End Function


sub LoadMoreContent(content, HandlerConfig,additionalFields)

    m.noContent.visible = false

    callback = {
        config: HandlerConfig
        content: content

        onReceive: function(data)
            m.SetContent(data)
        end function

        onError: function(data)
            if m.content.HandlerConfigCustom <> invalid then
                m.config = m.content.HandlerConfigCustom
                m.content.HandlerConfigCustom = invalid
                GetContentData(m, m.config, m.content)
            end if
        end function

        setContent: sub(content)
            'ShowBusySpinner(false)
        end sub
    }

    GetContentData(callback, HandlerConfig, content, additionalFields)
end sub


function ConvetToRowlistContent(data as object)

    if data <> invalid and data.count() > 0
        m.noContent.visible = false
    else
        m.noContent.visible = true
    end if

    m.Topbuttons.visible = true
    content = CreateObject("roSGNode", "ContentNode")
    for i=0 to data.count()-1 step 7
        row = CreateObject("roSGNode", "ContentNode")
        for j=i to i+6
            if data[j] <> invalid
                item = CreateObject("roSGNode", "ContentNode")
                item.update(data[j],true)
                row.appendchild(item)
            end if
        end for

        if row.GetchildCount() > 0
            content.appendchild(row)
        end if
    end for

    return content
end function

sub ShowBusySpinner(shouldShow)
    if shouldShow then
        if not m.spinner.visible then
            m.spinner.visible = true
            m.spinner.control = "start"
        end if
    else
        m.spinner.visible = false
        m.spinner.control = "stop"
    end if
end sub