Function init()
    m.logo = m.top.findnode("logo")

    m.LiveTVChecklist = m.top.findnode("LiveTVChecklist")
    m.LiveTVChecklist.ObserveField("checkedState", "onChecklistChanged")

    m.MoviesChecklist = m.top.findnode("MoviesChecklist")
    m.MoviesChecklist.ObserveField("checkedState", "onChecklistChanged")

    m.TVShowsChecklist = m.top.findnode("TVShowsChecklist")
    m.TVShowsChecklist.ObserveField("checkedState", "onChecklistChanged")

    m.top.ObserveField("wasShown", "OnWasShown")
    m.top.ObserveField("content", "OnContentChange")

    m.liveCatids = []
    m.movieCatids = []
    m.showsCatids = []
End Function

Function onChecklistChanged(event as object)
    node = event.GetRoSGNode().id
    added = []
    ids = event.getdata()
    i = 0
    for each id in ids
        if id = true
            if node = "LiveTVChecklist"
                added.Push(m.liveCatids[i])
            else if node =  "MoviesChecklist"
                added.Push(m.movieCatids[i])
            else if node = "TVShowsChecklist"
                added.Push(m.showsCatids[i])
            end if
        end if
        i = i + 1
    end for

    if node = "LiveTVChecklist"
        if added.count() > 0
            RegistryUtil().write("plive",FormatJson(added),m.global.manifest.key)
        else
            RegistryUtil().delete("plive",m.global.manifest.key)
        end if
    else if node =  "MoviesChecklist"
        if added.count() > 0
            RegistryUtil().write("pmovie",FormatJson(added),m.global.manifest.key)
        else
            RegistryUtil().delete("pmovie",m.global.manifest.key)
        end if
    else if node = "TVShowsChecklist"  
        if added.count() > 0
            RegistryUtil().write("pshows",FormatJson(added),m.global.manifest.key)
        else
            RegistryUtil().delete("pshows",m.global.manifest.key)
        end if  
    end if
end function

sub OnContentChange()
   if m.top.content <> invalid
      if m.top.content.FieldChanged <> invalid
        FieldChanged = m.top.content.FieldChanged
        m.top.content.SetFields({FieldChanged : invalid})
        if FieldChanged = "SetContent"
            if m.global.Cdata <> invalid
                m.logo.uri = m.global.Cdata.app_image.app_logo
            end if
            SetupCategories()
        end if
      end if
   end if
end sub


Function OnWasShown()
    if m.lastfocus <> invalid
        m.lastfocus.setfocus(true)
    end if
End Function


function SetupCategories()
    m.liveCatids = []

    if RegistryUtil().read("plive",m.global.manifest.key) <> invalid
        ids = parsejson(RegistryUtil().read("plive",m.global.manifest.key))
    else
        ids = []
    end if

    content = CreateObject("roSGNode", "ContentNode")
    datas = m.global.Livecats
    
    state = []
    for each data in datas
        item = CreateObject("roSGNode", "ContentNode")
        if ids <> invalid and ArrayUtil().contains(ids,data.category_id)
            state.push(true)
        else
            state.push(false)
        end if    
        m.liveCatids.Push(data.category_id)
        item.id = data.category_id
        item.TITLE = data.category_name
        content.appendChild(item)
    end for
    m.LiveTVChecklist.checkedState = state
    m.LiveTVChecklist.content = content
    m.LiveTVChecklist.setfocus(true)

    m.movieCatids = []

    if RegistryUtil().read("pmovie",m.global.manifest.key) <> invalid
        ids = parsejson(RegistryUtil().read("pmovie",m.global.manifest.key))
    else
        ids = []
    end if

    content = CreateObject("roSGNode", "ContentNode")
    datas = m.global.moviesCats
    state = []
    for each data in datas
        item = CreateObject("roSGNode", "ContentNode")
        if ids <> invalid and ArrayUtil().contains(ids,data.category_id)
            state.push(true)
        else
            state.push(false)
        end if    
        m.movieCatids.Push(data.category_id)
        item.id = data.category_id
        item.TITLE = data.category_name
        content.appendChild(item)
    end for
    m.MoviesChecklist.checkedState = state
    m.MoviesChecklist.content = content


    m.showsCatids = []

    if RegistryUtil().read("pshows",m.global.manifest.key) <> invalid
        ids = parsejson(RegistryUtil().read("pshows",m.global.manifest.key))
    else
        ids = []
    end if
    state = []
    content = CreateObject("roSGNode", "ContentNode")
    datas = m.global.tvshowsCats
 
    for each data in datas
        item = CreateObject("roSGNode", "ContentNode")
        if ids <> invalid and ArrayUtil().contains(ids,data.category_id)
            state.push(true)
        else
            state.push(false)
        end if    
        m.showsCatids.Push(data.category_id)
        item.id = data.category_id
        item.TITLE = data.category_name
        content.appendChild(item)
    end for
    m.TVShowsChecklist.checkedState = state
    m.TVShowsChecklist.content = content
end function


Function ReadFile(id as string)
    if MatchFiles("cachefs:/", id+".txt").count() = 1
        text = ReadAsciiFile("cachefs:/"+id+".txt")
        if text <> ""
            response =  parsejson(text)
            return response
        end if
    end if
    return invalid
End Function



function onKeyEvent(key as String, press as Boolean) as Boolean
    handled = false
    if press
        if key = "left"
            if m.TVShowsChecklist.hasfocus()
                m.MoviesChecklist.setfocus(true)
            else if m.MoviesChecklist.hasfocus()
                m.LiveTVChecklist.setfocus(true)    
            end if
        else if key = "right"
            if m.LiveTVChecklist.hasfocus()
                m.MoviesChecklist.setfocus(true)
            else if m.MoviesChecklist.hasfocus()
                m.TVShowsChecklist.setfocus(true)
            end if   
        end if
    end if
    return handled
end function



