sub GetContent()
    m.registry = RegistryUtil().read("UserInfo", m.global.manifest.key)  
    if m.registry <> invalid
        m.registry = parsejson(m.registry)  
    end if

    m.base_url = m.registry.server_info.server_protocol+"://"+m.registry.server_info.url+":"+m.registry.server_info.port+"/player_api.php?username="+m.registry.user_info.username+"&password="+m.registry.user_info.password
    if m.top <> invalid
        if m.top.id = "GetData"
            GetLiveTVCategories()
        end if
    end if
end sub

function GetLiveTVCategories()
    response = fetch({url: m.base_url+"&action=get_live_categories"})
    if response.ok
        m.cats = response.json()
        GetMoviesCategories()
    end if
end function


function GetMoviesCategories()
    cats = []
    channel = {
        category_id: "Fav"
        category_name: "Favorite"
        parent_id: 0
    }
    cats.push(channel)
    response = fetch({url: m.base_url+"&action=get_vod_categories"})
    if response.ok
        for each cat in response.json()
            cats.push(cat)
        end for
        m.global.addFields({moviesCats : cats})
        GetTVShowCategories()
    end if
end function

function GetTVShowCategories()
    cats = []
    channel = {
        category_id: "Fav"
        category_name: "Favorite"
        parent_id: 0
    }
    cats.push(channel)
    response = fetch({url: m.base_url+"&action=get_series_categories"})
    if response.ok
        for each cat in response.json()
            cats.push(cat)
        end for
       m.global.addFields({tvshowsCats : cats})
       GetLiveChannel()
    end if
end function

function GetLiveChannel()
    response = fetch({url: m.base_url+"&action=get_live_streams"})
    if response.ok
        ChannelArray(response.json())
        GetChannelByCat(response.json())
        SetCategories(m.cats)
    end if
    returnValue(m.top.id)
end function


function ChannelArray(data as object)
    m.channels = data
    m.channels.SortBy("num")
    m.global.addFields({channels : m.channels})
end function

function GetChannelByCat(data as object)
    m.channelByCat = {}
    for each channel in data
        if m.channelByCat.doesExist(channel.category_id)
            m.channelByCat[channel.category_id].push(channel)
        else
            m.channelByCat.addreplace(channel.category_id,[])
            m.channelByCat[channel.category_id].push(channel)
        end if
    end for
    m.global.addFields({channelByCat : m.channelByCat})
end function

function SetCategories(data as object)
    m.cats = []
    channel = {
        category_id: "All"
        category_name: "All Channels"
        parent_id: 0
    }
    m.cats.push(channel)
    
    channel = {
        category_id: "Fav"
        category_name: "Favorite"
        parent_id: 0
    }
    m.cats.push(channel)

    for each CatItem in data
        if m.channelByCat.doesExist(CatItem.category_id)
            m.cats.push(CatItem)
        end if
    end for
    m.global.addFields({Livecats : m.cats})
    EPGCat()
end function

Function EPGCat()
    cats = []
    for each cat in m.global.Livecats
        if cat.category_id = "Fav"
            data = GetFavData()
        else if cat.category_id = "All"
            data = m.global.channels
        else
            data = m.channelByCat[cat.category_id]
        end if
        counts = GetEPGChannel(data)
        
        if counts > 0
            cats.push(cat)
        end if
    end for
    m.global.addFields({EPGcats : cats})
End function


Function returnValue(id as string)
    if m.top.content.hasfield("FieldChanged")
        m.top.content.setfields({FieldChanged : id})
    else
        m.top.content.Addfields({FieldChanged : id})
    end if
End Function