sub GetContent()
    id = m.top.content.id
    m.registry = RegistryUtil().read("UserInfo", m.global.manifest.key)  
    if m.registry <> invalid
        m.registry = parsejson(m.registry)  
    end if

    blob = CreateObject("roByteArray")

    if m.global.Cdata.endpoint.epg_endpoint <> ""
        ? m.global.Cdata.endpoint.epg_endpoint+"?username="+m.registry.user_info.username+"&password="+m.registry.user_info.password+"&stream_id="+id+"&action=get_simple_data_table&dns="+m.registry.server_info.server_protocol+"://"+m.registry.server_info.url+":"+m.registry.server_info.port
        response = fetch({url:m.global.Cdata.endpoint.epg_endpoint+"?username="+m.registry.user_info.username+"&password="+m.registry.user_info.password+"&stream_id="+id+"&action=get_simple_data_table&dns="+m.registry.server_info.server_protocol+"://"+m.registry.server_info.url+":"+m.registry.server_info.port})
    else
        response = fetch({url: m.baseURL+"&action=get_simple_data_table&stream_id="+id+"&limit=3"})
    end if

    if response.ok
        json = response.json()
    end if

    programNodes = {
        children: []
    }
    if json <> invalid
        for each program in json.epg_listings
            ' create a node for the program and set its metadata fields
            programNode = {}
            if program.title <> invalid and program.title <> ""
                blob.FromBase64String(program.title)
                programNode.title = blob.ToAsciiString()
            else
                programNode.title = "---"
            end if

            if program.description <> invalid and program.description <> ""
                blob.FromBase64String(program.description)
                programNode.description = blob.ToAsciiString()
            end if

            programNode.playStart = program.start_timestamp.ToInt()
            programNode.playDuration = program.stop_timestamp.ToInt() - program.start_timestamp.ToInt()

            programNodes.children.Push(programNode)

        end for
    else
        programNode = {
            title : "Loading"
            playStart: 0
            playDuration : 0
        }
        programNodes.children.Push(programNode)
    end if
    m.top.content.Update(programNodes)
end sub
