' ********** Copyright 2017 Roku Corp.  All Rights Reserved. **********

' Converts associative array to a node of a given type
' @param inputAA associative array, which will be transformed to roSGNode
' @param nodeType type of node, which will be created
function Utils_AAToNode(inputAA = {} as Object, nodeType = "Node" as String) as Object
    node = createObject("roSGNode", nodeType)

    Utils_forceSetFields(node, inputAA)

    return node
end function


'converts AA to ContentNode
Function Utils_AAToContentNode(inputAA = {} as Object, nodeType = "ContentNode" as String)
    return Utils_AAToNode(inputAA, nodeType)
End Function


' Force sets fields to a given node. If node doesn't have a field, it adds it and then sets
' @param node roSGNode, to which you want to set fields
' @param fieldsToSet associative array of field names and values to be set
sub Utils_forceSetFields(node as Object, fieldsToSet as Object)
    ' if not fw_isSGNode(node) or not fw_isAssociativeArray(fieldsToSet) then return

    existingFields = {}
    newFields = {}

      'AA of node read-only fields for filtering'
    fieldsFilterAA = {
        focusedChild    :   "focusedChild"
        change          :   "change"
        metadata        :   "metadata"
    }

    for each field in fieldsToSet
        if node.hasField(field)
            if NOT fieldsFilterAA.doesExist(field) then existingFields[field] = fieldsToSet[field]
        else
            newFields[field] = fieldsToSet[field]
        end if
    end for

    node.setFields(existingFields)
    node.addFields(newFields)
end sub


'converts array of AAs to content node with child content nodes
Function Utils_ContentList2Node(contentList as Object) as Object
    result = createObject("roSGNode","ContentNode")

    for each itemAA in contentList
        item = Utils_AAToContentNode(itemAA, "ContentNode")
        result.appendChild(item)
    end for

    return result
End Function

function RegistryUtil() as Object
    registry = {

        '** Writes value to Registry
        '@param key Registry section key
        '@param val value to write
        '@param section Registry section name
        write: function(key as String, val as String, section = "default" as String) as Void
            sec = createObject("roRegistrySection", section)
            sec.write(key, val)
            sec.flush()
        end function

        '** Reads value from Registry
        '@param key Registry section key
        '@param section Registry section name
        read: function(key as String, section = "default" as String) as Dynamic
            sec = createObject("roRegistrySection", section)
            if sec.exists(key) then return sec.read(key)
            return invalid
        end function

        '** Retrieve all entries in the specified section
        '@param section Registry section name
        readSection: function(section = "default" as String) as Object
            sec = createObject("roRegistrySection", section)
            aa = {}
            keyList = sec.getKeyList()
            for each key in keyList
                aa[key] = m.read(key, section)
            end for
            return aa
        end function

        '** Deletes key value from Registry
        '@param key Registry section key
        '@param section Registry section name
        delete: function(key as String, section = "default" as String) as Dynamic
            sec = createObject("roRegistrySection", section)
            if sec.exists(key) then return sec.delete(key)
            return invalid
        end function

        '** Deletes all key values from the specified section
        '@param section Registry section name
        deleteSection: function(section = "default" as String) as Boolean
            reg = createObject("roRegistry")
            return reg.delete(section)
        end function

        '** Deletes all sections from the registry
        '@param section Registry section name
        clear: function()
            sectionList = m.getSections()
            for each section in sectionList
                m.deleteSection(section)
            end for
        end function

        '** Retrieve all sections in the registry
        getSections: function() as Object
            reg = createObject("roRegistry")
            return reg.getSectionList()
        end function
    }

    return registry
end function